/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.texture;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class Textures {
    private static HashMap<String, Integer> idMap = new HashMap();
    public static final String terrain = "/terrain.png";
    public static final String player = "/char.png";
    public static final String bloodM = "/bloodmonster.png";
    public static final String font = "/font.png";
    public static final String item = "/items.png";
    public static final String tCreatorE = "/thecreator.png";
    public static final String butterfly = "/butterfly.png";
    public static final String libtard = "/libtard.png";
    public static final String tactikalTemplar = "/tactikalTemplar.png";
    public static final String bigPharma = "/bigpharma.png";
    public static final String dynamiteEntity = "/entityDynamite.png";

    public static void bindNearest(String tex) {
        GL11.glBindTexture(3553, Textures.loadTexture(tex, 9728));
    }

    public static int loadTexture(String resourceName, int mode) {
        try {
            if (idMap.containsKey(resourceName)) {
                return idMap.get(resourceName);
            }
            IntBuffer e2 = BufferUtils.createIntBuffer(1);
            e2.clear();
            GL11.glGenTextures(e2);
            int id = e2.get(0);
            idMap.put(resourceName, id);
            System.out.println(String.valueOf(resourceName) + " -> " + id);
            GL11.glBindTexture(3553, id);
            GL11.glTexParameteri(3553, 10241, mode);
            GL11.glTexParameteri(3553, 10240, mode);
            BufferedImage img = ImageIO.read(Textures.class.getResourceAsStream(resourceName));
            int w = img.getWidth();
            int h2 = img.getHeight();
            ByteBuffer pixels = BufferUtils.createByteBuffer(w * h2 * 4);
            int[] rawPixels = new int[w * h2];
            img.getRGB(0, 0, w, h2, rawPixels, 0, w);
            int i2 = 0;
            while (i2 < rawPixels.length) {
                int a2 = rawPixels[i2] >> 24 & 0xFF;
                int r = rawPixels[i2] >> 16 & 0xFF;
                int g2 = rawPixels[i2] >> 8 & 0xFF;
                int b2 = rawPixels[i2] & 0xFF;
                rawPixels[i2] = a2 << 24 | b2 << 16 | g2 << 8 | r;
                ++i2;
            }
            pixels.asIntBuffer().put(rawPixels);
            GLU.gluBuild2DMipmaps(3553, 6408, w, h2, 6408, 5121, pixels);
            return id;
        }
        catch (IOException var14) {
            throw new RuntimeException("Failed to load texture: " + resourceName, var14);
        }
    }
}

